<?php
require_once '../core/config.php'; 
require_once '../core/database.php';

// اطمینان از لاگین بودن کاربر و وجود آیدی تیکت در URL
if (!isset($_SESSION['user_id']) || !isset($_GET['id'])) {
    header("Location: tickets.php");
    exit();
}

$user_id = $_SESSION['user_id'];
$ticket_id = (int)$_GET['id'];

// --- پردازش فرم ارسال پاسخ ---
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['submit_reply'])) {
    $message = trim($_POST['message']);
    if (!empty($message)) {
        // بررسی امنیتی: آیا این تیکت واقعا متعلق به این کاربر است؟
        $auth_stmt = $pdo->prepare("SELECT id FROM tickets WHERE id = ? AND user_id = ?");
        $auth_stmt->execute([$ticket_id, $user_id]);
        if ($auth_stmt->fetch()) {
            $pdo->beginTransaction();
            try {
                // 1. ثبت پاسخ جدید
                $reply_stmt = $pdo->prepare("INSERT INTO ticket_replies (ticket_id, user_id, message) VALUES (?, ?, ?)");
                $reply_stmt->execute([$ticket_id, $user_id, $message]);

                // 2. بروزرسانی وضعیت تیکت به "پاسخ مشتری"
                $update_stmt = $pdo->prepare("UPDATE tickets SET status = 'customer-reply', last_updated = NOW() WHERE id = ?");
                $update_stmt->execute([$ticket_id]);

                $pdo->commit();
                // رفرش صفحه برای نمایش پاسخ جدید
                header("Location: view_ticket.php?id=" . $ticket_id);
                exit;
            } catch (Exception $e) {
                $pdo->rollBack();
                $error_message = "خطایی در ارسال پاسخ رخ داد.";
            }
        }
    }
}

// --- دریافت اطلاعات تیکت و پاسخ‌ها برای نمایش ---
$stmt = $pdo->prepare("SELECT * FROM tickets WHERE id = ? AND user_id = ?");
$stmt->execute([$ticket_id, $user_id]);
$ticket = $stmt->fetch(PDO::FETCH_ASSOC);

// اگر تیکت یافت نشد یا متعلق به این کاربر نبود
if (!$ticket) {
    header("Location: tickets.php");
    exit();
}

// دریافت تمام پاسخ‌های این تیکت به همراه اطلاعات فرستنده
$replies_stmt = $pdo->prepare(
    "SELECT r.*, u.username, u.role 
     FROM ticket_replies r 
     JOIN users u ON r.user_id = u.id 
     WHERE r.ticket_id = ? 
     ORDER BY r.created_at ASC"
);
$replies_stmt->execute([$ticket_id]);
$replies = $replies_stmt->fetchAll(PDO::FETCH_ASSOC);

// آرایه‌های کمکی برای نمایش وضعیت و دپارتمان
$status_map = [ 'open' => ['text' => 'باز', 'class' => 'bg-blue-100 text-blue-800'], 'answered' => ['text' => 'پاسخ داده شده', 'class' => 'bg-green-100 text-green-800'], 'customer-reply' => ['text' => 'پاسخ مشتری', 'class' => 'bg-yellow-100 text-yellow-800'], 'closed' => ['text' => 'بسته شده', 'class' => 'bg-gray-200 text-gray-800'] ];
$department_map = ['support' => 'پشتیبانی عمومی', 'sales' => 'فروش و مالی', 'technical' => 'فنی'];

include 'includes/header.php';
include 'includes/sidebar.php'; 
?>

<main id="main-content" class="flex-1 p-6 mr-64 transition-all duration-300">
    <div class="mb-6">
        <div class="flex justify-between items-center">
            <h1 class="text-2xl font-bold text-gray-800">مشاهده تیکت #<?= $ticket['id'] ?></h1>
            <a href="tickets.php" class="text-sm text-primary hover:underline">بازگشت به لیست تیکت‌ها</a>
        </div>
        <p class="text-gray-600 mt-1"><?= htmlspecialchars($ticket['subject']) ?></p>
    </div>

    <div class="bg-white rounded-lg shadow-sm p-6">
        <div class="flex flex-wrap gap-x-8 gap-y-4 text-sm border-b pb-4 mb-6">
            <div><strong>دپارتمان:</strong> <?= $department_map[$ticket['department']] ?? '' ?></div>
            <div><strong>وضعیت:</strong> <span class="px-2 py-1 text-xs rounded-full <?= $status_map[$ticket['status']]['class'] ?? '' ?>"><?= $status_map[$ticket['status']]['text'] ?? '' ?></span></div>
            <div><strong>تاریخ ایجاد:</strong> <?= date("Y/m/d H:i", strtotime($ticket['created_at'])) ?></div>
        </div>

        <div class="space-y-6 max-h-[60vh] overflow-y-auto pr-2">
            <?php foreach($replies as $reply): ?>
                <?php if($reply['user_id'] === $user_id): // پیام‌های خود کاربر ?>
                    <div class="flex flex-col items-end">
                        <div class="bg-blue-500 text-white p-4 rounded-lg rounded-br-none max-w-xl">
                            <p><?= nl2br(htmlspecialchars($reply['message'])) ?></p>
                        </div>
                        <div class="text-xs text-gray-400 mt-1">شما در تاریخ <?= date("Y/m/d H:i", strtotime($reply['created_at'])) ?></div>
                    </div>
                <?php else: // پیام‌های ادمین/پشتیبان ?>
                     <div class="flex flex-col items-start">
                        <div class="bg-gray-100 p-4 rounded-lg rounded-bl-none max-w-xl">
                            <p class="text-gray-800"><?= nl2br(htmlspecialchars($reply['message'])) ?></p>
                        </div>
                        <div class="text-xs text-gray-400 mt-1">پشتیبانی در تاریخ <?= date("Y/m/d H:i", strtotime($reply['created_at'])) ?></div>
                    </div>
                <?php endif; ?>
            <?php endforeach; ?>
        </div>

        <?php if($ticket['status'] !== 'closed'): ?>
            <div class="border-t mt-6 pt-6">
                <h3 class="text-lg font-semibold text-gray-800 mb-2">ارسال پاسخ جدید</h3>
                <form action="view_ticket.php?id=<?= $ticket_id ?>" method="POST">
                    <div>
                        <textarea name="message" rows="5" class="w-full bg-white rounded-lg border border-gray-300 focus:border-primary focus:ring-1 focus:ring-primary/50 transition" required></textarea>
                    </div>
                    <div class="mt-4 flex justify-end">
                        <button type="submit" name="submit_reply" class="bg-primary text-white px-6 py-2 rounded-lg hover:bg-primary/90">ارسال پاسخ</button>
                    </div>
                </form>
            </div>
        <?php else: ?>
             <div class="border-t mt-6 pt-6 text-center text-gray-500">
                <p>این تیکت بسته شده است و امکان ارسال پاسخ جدید وجود ندارد.</p>
            </div>
        <?php endif; ?>
    </div>
</main>

<?php include 'includes/footer.php'; ?>