<?php
require_once '../core/config.php'; 
require_once '../core/database.php';

// اطمینان از اینکه کاربر لاگین کرده است
if (!isset($_SESSION['user_id'])) {
    header("Location: ../login.php");
    exit();
}
$user_id = $_SESSION['user_id'];

// دریافت لیست تمام تیکت‌های این کاربر از دیتابیس
$stmt = $pdo->prepare("SELECT * FROM tickets WHERE user_id = ? ORDER BY last_updated DESC");
$stmt->execute([$user_id]);
$tickets = $stmt->fetchAll(PDO::FETCH_ASSOC);

// آرایه‌های کمکی برای نمایش وضعیت و اولویت به فارسی
$status_map = [
    'open' => ['text' => 'باز', 'class' => 'bg-blue-100 text-blue-800'],
    'answered' => ['text' => 'پاسخ داده شده', 'class' => 'bg-green-100 text-green-800'],
    'customer-reply' => ['text' => 'پاسخ مشتری', 'class' => 'bg-yellow-100 text-yellow-800'],
    'closed' => ['text' => 'بسته شده', 'class' => 'bg-gray-200 text-gray-800']
];
$priority_map = [
    'low' => ['text' => 'کم', 'class' => 'text-gray-600'],
    'medium' => ['text' => 'متوسط', 'class' => 'text-orange-600'],
    'high' => ['text' => 'زیاد', 'class' => 'text-red-600']
];

include 'includes/header.php';
include 'includes/sidebar.php'; 
?>

<main id="main-content" class="flex-1 p-6 mr-64 transition-all duration-300">
    <div class="flex justify-between items-center mb-8">
        <h1 class="text-2xl font-bold text-gray-800">تیکت‌های پشتیبانی</h1>
        <a href="new_ticket.php" class="bg-primary text-white px-5 py-2 rounded-lg hover:bg-primary/90 transition-colors flex items-center space-x-2 space-x-reverse">
            <i class="ri-add-line"></i>
            <span>ارسال تیکت جدید</span>
        </a>
    </div>

    <div class="bg-white rounded-lg shadow-sm p-6">
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead>
                    <tr class="border-b-2 border-gray-200">
                        <th class="text-right py-3 px-4 text-sm font-medium text-gray-500">شناسه</th>
                        <th class="text-right py-3 px-4 text-sm font-medium text-gray-500">موضوع</th>
                        <th class="text-right py-3 px-4 text-sm font-medium text-gray-500">وضعیت</th>
                        <th class="text-right py-3 px-4 text-sm font-medium text-gray-500">آخرین بروزرسانی</th>
                        <th class="text-center py-3 px-4 text-sm font-medium text-gray-500"></th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (empty($tickets)): ?>
                        <tr><td colspan="5" class="text-center py-10 text-gray-500">شما تاکنون هیچ تیکتی ثبت نکرده‌اید.</td></tr>
                    <?php else: ?>
                        <?php foreach ($tickets as $ticket): ?>
                            <tr class="border-b border-gray-100 hover:bg-gray-50">
                                <td class="py-3 px-4 text-sm font-mono text-gray-600">#<?= $ticket['id'] ?></td>
                                <td class="py-3 px-4 text-sm font-semibold text-gray-800"><?= htmlspecialchars($ticket['subject']) ?></td>
                                <td class="py-3 px-4 text-sm">
                                    <span class="px-2 py-1 text-xs rounded-full <?= $status_map[$ticket['status']]['class'] ?? '' ?>">
                                        <?= $status_map[$ticket['status']]['text'] ?? '' ?>
                                    </span>
                                </td>
                                <td class="py-3 px-4 text-sm text-gray-500"><?= date("Y/m/d H:i", strtotime($ticket['last_updated'])) ?></td>
                                <td class="py-3 px-4 text-center">
                                    <a href="view_ticket.php?id=<?= $ticket['id'] ?>" class="text-primary hover:text-primary/80 font-semibold text-sm">مشاهده</a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</main>

<?php include 'includes/footer.php'; ?>