<?php
require_once '../core/config.php'; 
require_once '../core/database.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: ../login.php");
    exit();
}
$user_id = $_SESSION['user_id'];

$message = '';
$message_type = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $subject = trim($_POST['subject']);
    $department = $_POST['department'];
    $priority = $_POST['priority'];
    $ticket_message = trim($_POST['message']);

    if (empty($subject) || empty($department) || empty($priority) || empty($ticket_message)) {
        $message = 'تمام فیلدها الزامی هستند.';
        $message_type = 'error';
    } else {
        try {
            $pdo->beginTransaction();

            $stmt = $pdo->prepare("INSERT INTO tickets (user_id, subject, department, priority, status) VALUES (?, ?, ?, ?, 'open')");
            $stmt->execute([$user_id, $subject, $department, $priority]);
            $ticket_id = $pdo->lastInsertId();

            $reply_stmt = $pdo->prepare("INSERT INTO ticket_replies (ticket_id, user_id, message) VALUES (?, ?, ?)");
            $reply_stmt->execute([$ticket_id, $user_id, $ticket_message]);

            $pdo->commit();
            
            header("Location: view_ticket.php?id=" . $ticket_id);
            exit();

        } catch (Exception $e) {
            $pdo->rollBack();
            $message = 'خطایی در ثبت تیکت رخ داد. لطفاً دوباره تلاش کنید.';
            $message_type = 'error';
        }
    }
}

include 'includes/header.php';
include 'includes/sidebar.php'; 
?>

<main id="main-content" class="flex-1 p-6 mr-64 transition-all duration-300">
    <div class="mb-8">
        <h1 class="text-2xl font-bold text-gray-800">ارسال تیکت جدید</h1>
        <p class="text-gray-600 mt-1">سوال یا مشکل خود را با جزئیات کامل برای ما ارسال کنید.</p>
    </div>

    <?php if ($message): ?>
        <div class="mb-4 p-4 rounded-lg <?= $message_type === 'success' ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' ?>">
            <?= htmlspecialchars($message) ?>
        </div>
    <?php endif; ?>

    <div class="bg-white rounded-lg shadow-sm p-6">
        <form action="new_ticket.php" method="POST">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label for="subject" class="block text-sm font-medium text-gray-700 mb-1">موضوع</label>
                    <input type="text" name="subject" id="subject" class="w-full bg-white rounded-lg border border-gray-300 focus:border-primary focus:ring-1 focus:ring-primary/50 transition" required>
                </div>
                <div>
                    <label for="department" class="block text-sm font-medium text-gray-700 mb-1">دپارتمان</label>
                    <select name="department" id="department" class="w-full bg-white rounded-lg border border-gray-300 focus:border-primary focus:ring-1 focus:ring-primary/50 transition" required>
                        <option value="support">پشتیبانی عمومی</option>
                        <option value="sales">فروش و مالی</option>
                        <option value="technical">فنی</option>
                    </select>
                </div>
                <div class="md:col-span-2">
                    <label for="priority" class="block text-sm font-medium text-gray-700 mb-1">اولویت</label>
                    <select name="priority" id="priority" class="w-full bg-white rounded-lg border border-gray-300 focus:border-primary focus:ring-1 focus:ring-primary/50 transition" required>
                        <option value="low">کم</option>
                        <option value="medium" selected>متوسط</option>
                        <option value="high">زیاد</option>
                    </select>
                </div>
            </div>
            <div class="mt-6">
                <label for="message" class="block text-sm font-medium text-gray-700 mb-1">پیام شما</label>
                <textarea name="message" id="message" rows="8" class="w-full bg-white rounded-lg border border-gray-300 focus:border-primary focus:ring-1 focus:ring-primary/50 transition" required></textarea>
            </div>
            <div class="mt-6 flex items-center justify-end space-x-4 space-x-reverse">
                <a href="tickets.php" class="bg-gray-200 text-gray-800 px-5 py-2 rounded-lg hover:bg-gray-300 transition-colors">انصراف</a>
                <button type="submit" class="bg-primary text-white px-5 py-2 rounded-lg hover:bg-primary/90 transition-colors">ارسال تیکت</button>
            </div>
        </form>
    </div>
</main>

<?php include 'includes/footer.php'; ?>