<?php
require_once '../core/config.php'; 
require_once '../core/database.php';
use App\MarzbanAPI;

$user_id = $_SESSION['user_id'] ?? null;
if (!$user_id) {
    header("Location: ../login.php");
    exit();
}
$error_message = '';

if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['buy_plan'])) {
    $plan_id = $_POST['plan_id'];

    $user_stmt = $pdo->prepare("SELECT wallet_balance, referred_by FROM users WHERE id = ?");
    $user_stmt->execute([$user_id]);
    $user = $user_stmt->fetch(PDO::FETCH_ASSOC);

    $plan_stmt = $pdo->prepare("SELECT * FROM plans WHERE id = ? AND is_active = 1");
    $plan_stmt->execute([$plan_id]);
    $plan = $plan_stmt->fetch(PDO::FETCH_ASSOC);

    if ($user && $plan) {
        if ($user['wallet_balance'] >= $plan['price']) {
            $marzban_username = setting('marzban_user_prefix', 'user_') . substr(uniqid(), 7);
            $marzban_api = new MarzbanAPI();
            
            $on_hold_status = ($plan['on_hold_enabled'] == 1);
            $marzban_response = $marzban_api->createUser(
                $marzban_username,
                (int)$plan['traffic_gb'],
                (int)$plan['duration_days'],
                $on_hold_status
            );

            if (isset($marzban_response['username'])) {
                $pdo->beginTransaction();
                try {
                    $new_balance = $user['wallet_balance'] - $plan['price'];
                    $pdo->prepare("UPDATE users SET wallet_balance = ? WHERE id = ?")->execute([$new_balance, $user_id]);
                    
                    $sub_link = $marzban_response['subscription_url'] ?? 'لینک یافت نشد';
                    $expiry_date_db = ($plan['duration_days'] > 0) ? date('Y-m-d H:i:s', time() + ((int)$plan['duration_days'] * 86400)) : null;
                    
                    $order_stmt = $pdo->prepare("INSERT INTO orders (user_id, plan_id, marzban_username, sub_link, price, expiry_date) VALUES (?, ?, ?, ?, ?, ?)");
                    $order_stmt->execute([$user_id, $plan_id, $marzban_username, $sub_link, $plan['price'], $expiry_date_db]);
                    $order_id = $pdo->lastInsertId();

                    if (!empty($user['referred_by']) && (bool)setting('affiliate_system_enabled', 0)) {
                        $referrer_id = $user['referred_by'];
                        $order_count_stmt = $pdo->prepare("SELECT COUNT(*) FROM orders WHERE user_id = ?");
                        $order_count_stmt->execute([$user_id]);
                        $purchase_number = $order_count_stmt->fetchColumn();
                        $commission_percent = 0;
                        if ($purchase_number == 1) { $commission_percent = (float)setting('affiliate_commission_tier1', 0); }
                        elseif ($purchase_number == 2) { $commission_percent = (float)setting('affiliate_commission_tier2', 0); }
                        else { $commission_percent = (float)setting('affiliate_commission_tier3', 0); }

                        if ($commission_percent > 0) {
                            $commission_amount = floor($plan['price'] * ($commission_percent / 100));
                            if($commission_amount > 0){
                                $pdo->prepare("UPDATE users SET wallet_balance = wallet_balance + ? WHERE id = ?")->execute([$commission_amount, $referrer_id]);
                                $description = "کمیسیون از سفارش شماره " . $order_id;
                                $pdo->prepare("INSERT INTO transactions (user_id, amount, type, description, status) VALUES (?, ?, 'commission', ?, 'completed')")->execute([$referrer_id, $commission_amount, $description]);
                            }
                        }
                    }
                    
                    $pdo->commit();
                    $_SESSION['flash_message'] = "سرویس جدید با موفقیت خریداری و فعال شد!";
                    header("Location: my-services.php");
                    exit();

                } catch (Exception $e) {
                    $pdo->rollBack();
                    $error_message = "یک خطای سیستمی رخ داد. لطفاً با پشتیبانی تماس بگیرید.";
                    error_log("Transaction failed: " . $e->getMessage()); 
                }
            } else {
                $error_message = "خطا در ایجاد سرویس: " . ($marzban_response['error'] ?? 'پاسخ نامعتبر');
            }
        } else {
            $error_message = "موجودی کیف پول شما برای خرید این پلن کافی نیست.";
        }
    } else {
        $error_message = "پلن انتخاب شده نامعتبر است.";
    }
}

$plans = $pdo->query("SELECT * FROM plans WHERE is_active = 1 ORDER BY price ASC")->fetchAll(PDO::FETCH_ASSOC);

include 'includes/header.php';
include 'includes/sidebar.php';
?>

<main id="main-content" class="flex-1 p-6 mr-64 transition-all duration-300">
    <div class="mb-8">
        <h1 class="text-2xl font-bold text-gray-800">خرید سرویس جدید</h1>
        <p class="text-gray-600 mt-1">پلن مورد نظر خود را انتخاب و خریداری کنید.</p>
    </div>

    <?php if (!empty($error_message)): ?>
        <div class="mb-6 p-4 rounded-lg bg-red-100 text-red-800 shadow"><?= htmlspecialchars($error_message) ?></div>
    <?php endif; ?>

    <?php if (empty($plans)): ?>
        <div class="bg-yellow-100 text-yellow-800 p-6 rounded-lg text-center shadow">
            <h3 class="font-bold text-xl">در حال حاضر هیچ پلن فعالی برای خرید وجود ندارد.</h3>
        </div>
    <?php else: ?>
        <div class="grid grid-cols-1 md:grid-cols-2 xl:grid-cols-4 gap-6">
            <?php foreach($plans as $plan): ?>
                <div class="bg-white rounded-lg shadow-sm p-6 flex flex-col border hover:shadow-lg transition-shadow">
                    <h3 class="text-xl font-bold text-center text-primary mb-4"><?= htmlspecialchars($plan['name']) ?></h3>
                    <div class="text-center mb-6">
                        <span class="text-4xl font-bold text-gray-800"><?= number_format($plan['price']) ?></span>
                        <span class="text-gray-600">تومان</span>
                    </div>
                    <ul class="space-y-3 text-gray-600 text-sm flex-grow mb-6">
                        <li class="flex items-center"><i class="ri-time-line text-green-500 ml-2"></i><span>مدت: <strong><?= htmlspecialchars($plan['duration_days']) ?> روز</strong></span></li>
                        <li class="flex items-center"><i class="ri-database-2-line text-green-500 ml-2"></i><span>ترافیک: <strong><?= htmlspecialchars($plan['traffic_gb']) ?> گیگابایت</strong></span></li>
                        <li class="flex items-center"><i class="ri-group-line text-green-500 ml-2"></i><span>تعداد کاربر: <strong><?= htmlspecialchars($plan['user_limit']) ?></strong></span></li>
                    </ul>
                    <form action="buy-service.php" method="POST" onsubmit="return confirm('آیا از خرید این پلن با کسر هزینه از کیف پول خود مطمئن هستید؟')">
                        <input type="hidden" name="plan_id" value="<?= $plan['id'] ?>">
                        <button type="submit" name="buy_plan" class="w-full bg-green-500 text-white px-6 py-3 rounded-lg hover:bg-green-600 transition-colors font-bold">
                            خرید و فعالسازی آنی
                        </button>
                    </form>
                </div>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>
</main>
<?php include 'includes/footer.php'; ?>