<?php
require_once '../core/config.php'; 
require_once '../core/database.php';
use App\MarzbanAPI;

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'reseller' || !isset($_GET['order_id'])) {
    header("Location: dashboard.php");
    exit();
}

$reseller_id = $_SESSION['user_id'];
$order_id = (int)$_GET['order_id'];

// دریافت اطلاعات سفارش، پلن و کاربر نهایی
$stmt = $pdo->prepare(
    "SELECT o.*, p.name as plan_name, p.price, p.duration_days, p.traffic_gb, u.username as customer_username
     FROM orders o 
     JOIN plans p ON o.plan_id = p.id
     JOIN users u ON o.user_id = u.id
     WHERE o.id = ? AND u.reseller_id = ? AND o.status != 'terminated'"
);
$stmt->execute([$order_id, $reseller_id]);
$order = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$order) {
    header("Location: orders.php");
    exit();
}

// خواندن موجودی کیف پول نماینده
$wallet_stmt = $pdo->prepare("SELECT wallet_balance FROM users WHERE id = ?");
$wallet_stmt->execute([$reseller_id]);
$wallet_balance = $wallet_stmt->fetchColumn();

// دریافت درصد تخفیف نماینده
$discount_percent = (int)setting('reseller_discount_percent', 0);
$discounted_price = floor($order['price'] * (1 - ($discount_percent / 100)));

// پردازش فرم تمدید
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['confirm_renew'])) {
    if ($wallet_balance >= $discounted_price) {
        $api = new MarzbanAPI();
        $renew_response = $api->renewUser($order['marzban_username'], (int)$order['traffic_gb'], (int)$order['duration_days']);

        if (isset($renew_response['username'])) {
            $new_balance = $wallet_balance - $discounted_price;
            $pdo->prepare("UPDATE users SET wallet_balance = ? WHERE id = ?")->execute([$new_balance, $reseller_id]);

            $new_expiry_date = date('Y-m-d H:i:s', $renew_response['expire']);
            $pdo->prepare("UPDATE orders SET expiry_date = ?, status = 'active' WHERE id = ?")->execute([$new_expiry_date, $order_id]);

            $_SESSION['flash_message'] = "سرویس برای کاربر " . htmlspecialchars($order['customer_username']) . " با موفقیت تمدید شد.";
            $_SESSION['flash_message_type'] = 'success';
            header("Location: orders.php");
            exit();
        } else {
            $error_message = "خطا در تمدید سرویس: " . ($renew_response['error'] ?? 'پاسخ نامعتبر');
        }
    } else {
        $error_message = "موجودی کیف پول شما برای تمدید این سرویس کافی نیست.";
    }
}

include 'includes/header.php';
include 'includes/sidebar.php'; 
?>

<main id="main-content" class="flex-1 p-6 mr-64 transition-all duration-300">
    <div class="mb-8">
        <h1 class="text-2xl font-bold text-gray-800">تاییدیه تمدید سرویس برای مشتری</h1>
    </div>

    <?php if (isset($error_message)): ?>
        <div class="mb-4 p-4 rounded-lg bg-red-100 text-red-800"><?= htmlspecialchars($error_message) ?></div>
    <?php endif; ?>

    <div class="bg-white rounded-lg shadow-sm p-6 max-w-lg mx-auto">
        <div class="space-y-4 text-gray-700 border-b pb-4 mb-4">
            <div class="flex justify-between"><span>مشتری:</span> <strong class="font-semibold"><?= htmlspecialchars($order['customer_username']) ?></strong></div>
            <div class="flex justify-between"><span>سرویس:</span> <strong class="font-mono"><?= htmlspecialchars($order['marzban_username']) ?></strong></div>
            <div class="flex justify-between"><span>پلن تمدید:</span> <strong><?= htmlspecialchars($order['plan_name']) ?></strong></div>
            <div class="flex justify-between"><span>تاریخ انقضای فعلی:</span> <strong class="text-red-600"><?= date("Y/m/d", strtotime($order['expiry_date'])) ?></strong></div>
        </div>
        <div class="space-y-4 text-gray-800">
            <div class="flex justify-between"><span>قیمت اصلی پلن:</span> <span class="line-through text-gray-400"><?= number_format($order['price']) ?> تومان</span></div>
            <div class="flex justify-between text-green-600 font-semibold"><span>هزینه برای شما (با تخفیف <?= $discount_percent ?>%):</span> <span><?= number_format($discounted_price) ?> تومان</span></div>
            <hr>
            <div class="flex justify-between font-semibold"><span>موجودی کیف پول شما:</span> <span><?= number_format($wallet_balance ?? 0) ?> تومان</span></div>
        </div>

        <form action="renew-service.php?order_id=<?= $order_id ?>" method="POST" class="mt-6">
            <?php if (($wallet_balance ?? 0) >= $discounted_price): ?>
                <button type="submit" name="confirm_renew" class="w-full bg-blue-500 text-white py-3 rounded-lg font-semibold hover:bg-blue-600">
                    تایید و تمدید برای مشتری
                </button>
            <?php else: ?>
                <div class="w-full bg-red-100 text-red-700 py-3 rounded-lg text-center">
                    موجودی کافی نیست! لطفاً ابتدا کیف پول خود را شارژ کنید.
                </div>
            <?php endif; ?>
            <a href="orders.php" class="block text-center mt-3 text-sm text-gray-600 hover:text-primary">بازگشت به لیست سفارشات</a>
        </form>
    </div>
</main>

<?php include 'includes/footer.php'; ?>