<?php
require_once '../core/config.php';
require_once '../core/database.php';
use App\MarzbanAPI;

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'reseller') {
    header("Location: ../login.php");
    exit();
}
$reseller_id = $_SESSION['user_id'];

if (isset($_SESSION['flash_message'])) {
    $message = $_SESSION['flash_message'];
    $message_type = $_SESSION['flash_message_type'] ?? 'success';
    unset($_SESSION['flash_message'], $_SESSION['flash_message_type']);
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $api = new MarzbanAPI();
    $redirect_url = $_SERVER['REQUEST_URI'];
    $order_id = $_POST['order_id'];

    $auth_stmt = $pdo->prepare("SELECT o.id FROM orders o JOIN users u ON o.user_id = u.id WHERE o.id = ? AND u.reseller_id = ?");
    $auth_stmt->execute([$order_id, $reseller_id]);
    if (!$auth_stmt->fetch()) {
        $_SESSION['flash_message'] = "دسترسی غیرمجاز!";
        $_SESSION['flash_message_type'] = 'error';
        header("Location: " . $redirect_url);
        exit;
    }

    $action = $_POST['action'] ?? '';

    try {
        $pdo->beginTransaction();
        $marzban_username = $_POST['marzban_username'];

        if ($action === 'add_to_service') {
            $add_days = (int)($_POST['add_days'] ?? 0);
            $add_gb = (int)($_POST['add_gb'] ?? 0);
            if ($add_days > 0 || $add_gb > 0) {
                $price_per_day = (int)setting('price_per_day_addon', 1000);
                $price_per_gb = (int)setting('price_per_gb_addon', 3000);
                $total_cost = ($add_days * $price_per_day) + ($add_gb * $price_per_gb);

                $wallet_stmt = $pdo->prepare("SELECT wallet_balance FROM users WHERE id = ?");
                $wallet_stmt->execute([$reseller_id]);
                $wallet_balance = $wallet_stmt->fetchColumn();

                if ($wallet_balance >= $total_cost) {
                    $result = $api->add_to_service($marzban_username, $add_days, $add_gb);
                    if (isset($result['username'])) {
                        $pdo->prepare("UPDATE users SET wallet_balance = wallet_balance - ? WHERE id = ?")->execute([$total_cost, $reseller_id]);
                        $new_expiry_date = date('Y-m-d H:i:s', $result['expire']);
                        $pdo->prepare("UPDATE orders SET expiry_date = ? WHERE id = ?")->execute([$new_expiry_date, $order_id]);
                        $_SESSION['flash_message'] = "تغییرات با موفقیت اعمال شد.";
                    } else { throw new Exception($result['error'] ?? 'خطای ناشناس از API'); }
                } else { throw new Exception("موجودی کیف پول شما برای این عملیات کافی نیست."); }
            }
        } elseif ($action === 'delete_service') {
            $result = $api->deleteUser($marzban_username);
            if ($result === true || (isset($result['error']) && str_contains($result['error'], 'User not found'))) {
                $pdo->prepare("UPDATE orders SET status = 'terminated', terminated_at = NOW(), terminated_by = ? WHERE id = ?")->execute([$reseller_id, $order_id]);
                $_SESSION['flash_message'] = "سرویس خاتمه یافت.";
            } else { throw new Exception($result['error'] ?? 'خطای ناشناس از API'); }
        } elseif ($action === 'modify_status') {
            $new_status = $_POST['new_status'];
            $result = $api->modifyUser($marzban_username, ['status' => $new_status]);
            if (isset($result['username'])) {
                $pdo->prepare("UPDATE orders SET status = ? WHERE id = ?")->execute([$new_status, $order_id]);
                $_SESSION['flash_message'] = "وضعیت سرویس تغییر کرد.";
            } else { throw new Exception($result['error'] ?? 'خطای ناشناس از API'); }
        }

        $pdo->commit();
        $_SESSION['flash_message_type'] = 'success';
    } catch (Exception $e) {
        $pdo->rollBack();
        $_SESSION['flash_message'] = 'خطا: ' . $e->getMessage();
        $_SESSION['flash_message_type'] = 'error';
    }
    header("Location: " . $redirect_url);
    exit;
}

$sql = "SELECT o.*, u.username as customer_username, p.name as plan_name 
        FROM orders o
        JOIN users u ON o.user_id = u.id
        JOIN plans p ON o.plan_id = p.id
        WHERE u.reseller_id = ? 
        ORDER BY o.order_date DESC";
$orders_stmt = $pdo->prepare($sql);
$orders_stmt->execute([$reseller_id]);
$orders = $orders_stmt->fetchAll(PDO::FETCH_ASSOC);

include 'includes/header.php';
include 'includes/sidebar.php';
?>

<main id="main-content" class="flex-1 p-6 mr-64 transition-all duration-300">
    <div class="mb-8">
        <h1 class="text-2xl font-bold text-gray-800">تاریخچه سفارشات شما</h1>
        <p class="text-gray-600 mt-1">در اینجا لیست تمام سرویس‌هایی که برای کاربران خود خریداری کرده‌اید را مشاهده و مدیریت کنید.</p>
    </div>
    
    <?php if (isset($message)): ?>
        <div class="mb-4 p-4 rounded-lg <?= $message_type === 'success' ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' ?>"><?= htmlspecialchars($message) ?></div>
    <?php endif; ?>

    <div class="bg-white rounded-lg shadow-sm p-6">
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead>
                    <tr class="border-b-2 border-gray-200">
                        <th class="text-right py-3 px-4 text-sm font-medium text-gray-500">مشتری</th>
                        <th class="text-right py-3 px-4 text-sm font-medium text-gray-500">نام کاربری مرزبان</th>
                        <th class="text-right py-3 px-4 text-sm font-medium text-gray-500">تاریخ انقضا</th>
                        <th class="text-right py-3 px-4 text-sm font-medium text-gray-500">وضعیت</th>
                        <th class="text-center py-3 px-4 text-sm font-medium text-gray-500">عملیات</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (empty($orders)): ?>
                        <tr><td colspan="5" class="text-center py-6 text-gray-500">هنوز هیچ سفارشی ثبت نکرده‌اید.</td></tr>
                    <?php else: ?>
                        <?php foreach ($orders as $order): ?>
                            <tr class="border-b border-gray-100 hover:bg-gray-50">
                                <td class="py-3 px-4 font-semibold"><?= htmlspecialchars($order['customer_username']) ?></td>
                                <td class="py-3 px-4 font-mono text-gray-800"><?= htmlspecialchars($order['marzban_username']) ?></td>
                                <td class="py-3 px-4 text-gray-800"><?= $order['expiry_date'] ? date("Y/m/d", strtotime($order['expiry_date'])) : 'نامحدود' ?></td>
                                <td class="py-3 px-4">
                                    <?php 
                                        $is_expired = $order['expiry_date'] && strtotime($order['expiry_date']) < time();
                                        if($is_expired && $order['status'] !== 'terminated') {
                                            echo '<span class="px-2 py-1 text-xs rounded-full bg-red-100 text-red-800">منقضی شده</span>';
                                        } else {
                                            $status_map = ['active' => 'bg-green-100 text-green-800', 'disabled' => 'bg-yellow-100 text-yellow-800', 'terminated' => 'bg-gray-200 text-gray-800'];
                                            $status_text_map = ['active' => 'فعال', 'disabled' => 'غیرفعال', 'terminated' => 'خاتمه یافته'];
                                            echo '<span class="px-2 py-1 text-xs rounded-full ' . ($status_map[$order['status']] ?? '') . '">' . ($status_text_map[$order['status']] ?? '') . '</span>';
                                        }
                                    ?>
                                </td>
                                <td class="py-3 px-4 text-center">
                                    <div class="flex items-center justify-center gap-x-1">
                                    <?php if($order['status'] !== 'terminated'): ?>
                                        <a href="renew-service.php?order_id=<?= $order['id'] ?>" title="تمدید سرویس" class="w-8 h-8 flex items-center justify-center text-blue-500 hover:bg-blue-50 rounded-lg"><i class="ri-refresh-line ri-lg"></i></a>
                                    <?php endif; ?>
                                    
                                    <?php if(in_array($order['status'], ['active', 'disabled']) && !$is_expired): ?>
                                        <button type="button" class="edit-service-btn w-8 h-8 flex items-center justify-center text-indigo-500 hover:bg-indigo-50 rounded-lg" data-order-id="<?= $order['id'] ?>" data-username="<?= htmlspecialchars($order['marzban_username']) ?>" title="افزودن روز/حجم"><i class="ri-edit-2-line ri-lg"></i></button>
                                        <?php if ($order['status'] === 'active'): ?>
                                            <form action="orders.php" method="POST"><input type="hidden" name="action" value="modify_status"><input type="hidden" name="order_id" value="<?= $order['id'] ?>"><input type="hidden" name="marzban_username" value="<?= $order['marzban_username'] ?>"><input type="hidden" name="new_status" value="disabled"><button type="submit" title="غیرفعال کردن" class="w-8 h-8 flex items-center justify-center text-yellow-500 hover:bg-yellow-50 rounded-lg"><i class="ri-pause-circle-line ri-lg"></i></button></form>
                                        <?php else: ?>
                                            <form action="orders.php" method="POST"><input type="hidden" name="action" value="modify_status"><input type="hidden" name="order_id" value="<?= $order['id'] ?>"><input type="hidden" name="marzban_username" value="<?= $order['marzban_username'] ?>"><input type="hidden" name="new_status" value="active"><button type="submit" title="فعال کردن" class="w-8 h-8 flex items-center justify-center text-green-500 hover:bg-green-50 rounded-lg"><i class="ri-play-circle-line ri-lg"></i></button></form>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                    
                                    <?php if($order['status'] !== 'terminated'): ?>
                                        <form action="orders.php" method="POST" onsubmit="return confirm('آیا از خاتمه دادن به این سرویس مطمئن هستید؟');"><input type="hidden" name="action" value="delete_service"><input type="hidden" name="order_id" value="<?= $order['id'] ?>"><input type="hidden" name="marzban_username" value="<?= $order['marzban_username'] ?>"><button type="submit" title="حذف سرویس" class="w-8 h-8 flex items-center justify-center text-red-500 hover:bg-red-50 rounded-lg"><i class="ri-delete-bin-line ri-lg"></i></button></form>
                                    <?php else: ?>
                                        <span class="text-gray-400 text-xs">—</span>
                                    <?php endif; ?>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</main>

<div id="edit-service-modal" class="hidden fixed inset-0 bg-black bg-opacity-60 flex items-center justify-center z-50 p-4">
    <div class="bg-white rounded-lg shadow-xl p-6 w-full max-w-md">
        <div class="flex justify-between items-center border-b pb-3 mb-4">
            <h2 class="text-xl font-semibold">افزودن روز/حجم به سرویس</h2>
            <button id="close-edit-modal-btn" class="text-gray-500"><i class="ri-close-line ri-lg"></i></button>
        </div>
        <form id="edit-service-form" action="orders.php" method="POST">
            <input type="hidden" name="action" value="add_to_service">
            <input type="hidden" name="order_id" id="edit_order_id">
            <input type="hidden" name="marzban_username" id="edit_marzban_username">
            <p class="text-sm mb-4">به سرویس <strong id="username_to_edit" class="font-mono"></strong></p>
            <div class="space-y-4">
                <div><label for="add_days" class="block text-sm font-medium text-gray-700">تعداد روز برای افزودن</label><input type="number" name="add_days" id="add_days" value="0" min="0" class="mt-1 w-full bg-gray-50 rounded-lg border-gray-300"></div>
                <div><label for="add_gb" class="block text-sm font-medium text-gray-700">مقدار حجم برای افزودن (GB)</label><input type="number" name="add_gb" id="add_gb" value="0" min="0" class="mt-1 w-full bg-gray-50 rounded-lg border-gray-300"></div>
            </div>
            <div id="cost-preview" class="mt-4 p-3 bg-blue-50 border border-blue-200 rounded-lg text-center hidden">
                <span class="text-sm">هزینه این عملیات: </span>
                <span id="calculated-cost" class="font-bold text-lg">0</span>
                <span class="text-sm"> تومان</span>
            </div>
            <div class="mt-6 flex justify-end"><button type="submit" class="bg-primary text-white px-6 py-2 rounded-lg">اعمال تغییرات</button></div>
        </form>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const editModal = document.getElementById('edit-service-modal');
    if(editModal) {
        const closeEditBtn = document.getElementById('close-edit-modal-btn');
        const addDaysInput = document.getElementById('add_days');
        const addGbInput = document.getElementById('add_gb');
        const costPreview = document.getElementById('cost-preview');
        const calculatedCostEl = document.getElementById('calculated-cost');
        
        const pricePerDay = <?= (int)setting('price_per_day_addon', 1000) ?>;
        const pricePerGb = <?= (int)setting('price_per_gb_addon', 3000) ?>;

        function updateCost() {
            const days = parseInt(addDaysInput.value) || 0;
            const gb = parseInt(addGbInput.value) || 0;
            const totalCost = (days * pricePerDay) + (gb * pricePerGb);
            
            if (totalCost > 0) {
                calculatedCostEl.textContent = totalCost.toLocaleString('fa-IR');
                costPreview.classList.remove('hidden');
            } else {
                costPreview.classList.add('hidden');
            }
        }

        addDaysInput.addEventListener('input', updateCost);
        addGbInput.addEventListener('input', updateCost);

        document.querySelectorAll('.edit-service-btn').forEach(button => {
            button.addEventListener('click', function() {
                document.getElementById('edit_order_id').value = this.dataset.orderId;
                document.getElementById('edit_marzban_username').value = this.dataset.username;
                document.getElementById('username_to_edit').textContent = this.dataset.username;
                addDaysInput.value = 0;
                addGbInput.value = 0;
                updateCost();
                editModal.classList.remove('hidden');
            });
        });

        closeEditBtn.addEventListener('click', () => editModal.classList.add('hidden'));
        editModal.addEventListener('click', (e) => {
            if (e.target === editModal) editModal.classList.add('hidden');
        });
    }
});
</script>

<?php include 'includes/footer.php'; ?>