<?php
// فقط هدر را فراخوانی می‌کنیم که تمام کارهای اولیه را انجام می‌دهد
include 'includes/header.php'; 

$settings = setting(null);
$min_deposit = $settings['min_deposit'] ?? 10000;
$max_deposit = $settings['max_deposit'] ?? 1000000;

include 'includes/sidebar.php'; 
?>

<main id="main-content" class="flex-1 p-6 mr-64 transition-all duration-300">
    <div class="mb-8">
        <h1 class="text-2xl font-bold text-gray-800">کیف پول نمایندگی</h1>
        <p class="text-gray-600 mt-1">موجودی خود را مدیریت کرده و برای خرید سرویس برای کاربرانتان، حساب خود را شارژ کنید.</p>
    </div>

    <?php if (isset($_SESSION['payment_error'])): ?>
        <div class="mb-4 p-4 rounded-lg bg-red-100 text-red-800">
            <?= htmlspecialchars($_SESSION['payment_error']); unset($_SESSION['payment_error']); ?>
        </div>
    <?php endif; ?>

    <div class="bg-white rounded-lg shadow-sm p-6">
        <h3 class="text-lg font-semibold text-gray-800 mb-4 border-b pb-3">شارژ کیف پول</h3>
        <form action="../payment-request.php" method="POST">
            <div>
                <label for="amount" class="block text-sm font-medium text-gray-700">مبلغ شارژ</label>
                <div class="relative mt-1">
                    <div class="pointer-events-none absolute inset-y-0 left-0 flex items-center pl-3">
                        <span class="text-gray-500 sm:text-sm">تومان</span>
                    </div>
                    <input type="number" name="amount" id="amount" 
                           class="w-full bg-gray-50 rounded-lg border-gray-300 pl-12 text-left"
                           placeholder="0"
                           min="<?= $min_deposit ?>" max="<?= $max_deposit ?>" required>
                </div>
                <p class="mt-2 text-xs text-gray-500">
                    حداقل مبلغ: <?= number_format($min_deposit) ?> تومان | حداکثر مبلغ: <?= number_format($max_deposit) ?> تومان
                </p>
            </div>
            <div class="mt-6">
                <button type="submit" class="w-full bg-green-500 text-white py-3 rounded-lg font-semibold hover:bg-green-600 transition-colors">
                    <i class="ri-secure-payment-line align-middle"></i>
                    پرداخت و شارژ حساب
                </button>
            </div>
        </form>
    </div>
</main>

<?php include 'includes/footer.php'; ?>