<?php
// فعال کردن نمایش تمام خطاها برای دیباگینگ
ini_set('display_errors', 1);
error_reporting(E_ALL);

// تنظیم هدر خروجی به صورت JSON
header('Content-Type: application/json; charset=utf-8');

// فراخوانی فایل‌های اصلی
require_once '../../core/config.php';
require_once '../../core/database.php';

// تابع برای ارسال پاسخ JSON و خروج
function api_response($status_code, $data) {
    http_response_code($status_code);
    echo json_encode($data, JSON_UNESCAPED_UNICODE);
    exit;
}

// ۱. دریافت کلید API از هدر Authorization
$auth_header = $_SERVER['HTTP_AUTHORIZATION'] ?? '';
if (!preg_match('/Bearer\s(\S+)/', $auth_header, $matches)) {
    api_response(401, ['error' => 'کلید API ارسال نشده است.']);
}
$api_key = $matches[1];

// ۲. اعتبارسنجی کلید API
$stmt = $pdo->prepare("SELECT id, role FROM users WHERE api_key = ?");
$stmt->execute([$api_key]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$user) {
    api_response(401, ['error' => 'کلید API نامعتبر است.']);
}

// اطمینان از اینکه کلید متعلق به یک نماینده است
if ($user['role'] !== 'reseller') {
    api_response(403, ['error' => 'این کلید API دسترسی لازم را ندارد.']);
}

// ۳. دریافت لیست پلن‌های فعال
try {
    $plans_stmt = $pdo->query("SELECT id, name, duration_days, price, traffic_gb FROM plans WHERE is_active = 1 ORDER BY price ASC");
    $plans = $plans_stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // دریافت درصد تخفیف نماینده
    $discount_percent = (int)setting('reseller_discount_percent', 0);

    // افزودن قیمت با تخفیف به هر پلن
    foreach ($plans as &$plan) {
        $plan['reseller_price'] = floor($plan['price'] * (1 - ($discount_percent / 100)));
    }

    api_response(200, ['success' => true, 'plans' => $plans]);

} catch (PDOException $e) {
    api_response(500, ['error' => 'خطای داخلی سرور در دریافت اطلاعات.']);
}