<?php
// acc/api/v1/bot_handler.php
header('Content-Type: application/json; charset=utf-8');

require_once __DIR__ . '/../../core/config.php';
use App\MarzbanAPI;

/**
 * تابع برای ساخت پاسخ نهایی به فرمت JSON
 */
function create_api_response($method, $payload) {
    global $pdo;
    $payload['bot_token'] = setting('telegram_main_bot_token');
    echo json_encode(['method' => $method, 'payload' => $payload], JSON_UNESCAPED_UNICODE);
    exit;
}

/**
 * تابع برای ارسال پیام "لطفا متصل شوید"
 */
function request_to_link_account($chat_id) {
    $reply_text = "برای استفاده از این قابلیت، ابتدا باید حساب تلگرام خود را متصل کنید.\n\n";
    $reply_text .= "لطفاً شناسه عددی زیر را کپی کرده و در صفحه «پروفایل» خود در وبسایت وارد کنید:\n\n";
    $reply_text .= "`" . $chat_id . "`";
    $login_keyboard = ['inline_keyboard' => [[['text' => 'ورود به پنل کاربری', 'url' => BASE_URL . 'login.php']]]];
    $payload = ['chat_id' => $chat_id, 'text' => $reply_text, 'parse_mode' => 'Markdown', 'reply_markup' => json_encode($login_keyboard)];
    create_api_response('sendMessage', $payload);
}

// --- منطق اصلی ربات ---

// بررسی کلید امنیتی
$secret_key_from_header = $_SERVER['HTTP_X_API_SECRET'] ?? '';
$actual_secret_key = setting('api_secret_key');
if (empty($actual_secret_key) || $secret_key_from_header !== $actual_secret_key) {
    http_response_code(403);
    exit;
}

// دریافت ورودی از وبهوک
$update = json_decode(file_get_contents("php://input"), true);
if (!$update) { exit; }


// پردازش کلیک روی دکمه‌های شیشه‌ای (Callback Query)
if (isset($update['callback_query'])) {
    $chat_id = $update['callback_query']['message']['chat']['id'];
    $message_id = $update['callback_query']['message']['message_id'];
    $callback_data = $update['callback_query']['data'];
    
    $user_stmt = $pdo->prepare("SELECT * FROM users WHERE telegram_chat_id = ?");
    $user_stmt->execute([$chat_id]);
    $user = $user_stmt->fetch(PDO::FETCH_ASSOC);

    if (!$user) { request_to_link_account($chat_id); exit; }

    if (strpos($callback_data, 'details_') === 0) {
        $username = substr($callback_data, strlen('details_'));
        $api = new MarzbanAPI();
        $marzban_user = $api->getUser($username);
        
        if (isset($marzban_user['username'])) {
            $used_gb = round(($marzban_user['used_traffic'] ?? 0) / (1024**3), 2);
            $total_gb = round(($marzban_user['data_limit'] ?? 0) / (1024**3), 2);
            $remaining_gb = ($total_gb > 0) ? round($total_gb - $used_gb, 2) : 'نامحدود';
            $expire_date = $marzban_user['expire'] > 0 ? date("Y/m/d", $marzban_user['expire']) : 'نامحدود';
            
            $details_text = "جزئیات سرویس: `" . htmlspecialchars($username) . "`\n\n";
            $details_text .= "📊 **حجم کل:** " . $total_gb . " گیگابایت\n";
            $details_text .= "📈 **حجم باقی‌مانده:** " . $remaining_gb . " گیگابایت\n";
            $details_text .= "📅 **تاریخ انقضا:** " . $expire_date . "\n\n";
            $details_text .= "🔗 **لینک اشتراک:**\n`" . htmlspecialchars($marzban_user['subscription_url']) . "`";

            $back_keyboard = ['inline_keyboard' => [[['text' => 'بازگشت 🔙', 'callback_data' => 'back_to_services']]]];
            $payload = ['chat_id' => $chat_id, 'message_id' => $message_id, 'text' => $details_text, 'parse_mode' => 'Markdown', 'reply_markup' => json_encode($back_keyboard)];
            create_api_response('editMessageText', $payload);
        } else {
            $details_text = "اطلاعات سرویس: `" . htmlspecialchars($username) . "`\n\n";
            $details_text .= "❌ **وضعیت:** این سرویس از سرور حذف شده است.";
            $back_keyboard = ['inline_keyboard' => [[['text' => 'بازگشت 🔙', 'callback_data' => 'back_to_services']]]];
            create_api_response('editMessageText', ['chat_id' => $chat_id, 'message_id' => $message_id, 'text' => $details_text, 'parse_mode' => 'Markdown', 'reply_markup' => json_encode($back_keyboard)]);
        }
    }
    elseif ($callback_data === 'back_to_services') {
        $services_stmt = $pdo->prepare("SELECT o.marzban_username, p.name as plan_name FROM orders o JOIN plans p ON o.plan_id = p.id WHERE o.user_id = ? AND o.status = 'active' AND o.expiry_date > NOW()");
        $services_stmt->execute([$user['id']]);
        $services = $services_stmt->fetchAll(PDO::FETCH_ASSOC);
        
        $reply_text = "لیست سرویس‌های فعال شما:";
        $inline_keyboard = [];
        foreach ($services as $service) {
            $button_text = htmlspecialchars($service['plan_name']) . " (`" . htmlspecialchars($service['marzban_username']) . "`)";
            $inline_keyboard[] = [['text' => $button_text, 'callback_data' => 'details_' . $service['marzban_username']]];
        }
        if (empty($inline_keyboard)) {
            $reply_text = "شما سرویس فعالی ندارید.";
        }
        
        $payload = ['chat_id' => $chat_id, 'message_id' => $message_id, 'text' => $reply_text, 'parse_mode' => 'Markdown', 'reply_markup' => json_encode(['inline_keyboard' => $inline_keyboard])];
        create_api_response('editMessageText', $payload);
    }
    exit;
}


// پردازش پیام‌های متنی
if (isset($update['message'])) {
    $chat_id = $update['message']['chat']['id'];
    $text = $update['message']['text'] ?? '';
    $first_name = $update['message']['from']['first_name'] ?? '';

    $admin_chat_id = setting('telegram_admin_chat_id');
    if (!empty($admin_chat_id) && $chat_id == $admin_chat_id) {
        $admin_keyboard = ['keyboard' => [[['text' => 'آمار کلی 📊']],[['text' => 'ارسال اعلان به همه 📢']]], 'resize_keyboard' => true];
        $payload = ['chat_id' => $chat_id, 'text' => "سلام ادمین عزیز!", 'reply_markup' => json_encode($admin_keyboard)];
        if ($text !== '/start') {
            $payload['text'] = "دستور ادمین نامشخص است.";
        }
        create_api_response('sendMessage', $payload);
    }

    $stmt = $pdo->prepare("SELECT * FROM users WHERE telegram_chat_id = ?");
    $stmt->execute([$chat_id]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);
    
    $main_keyboard = ['keyboard' => [[['text' => 'موجودی کیف پول 💰']], [['text' => 'سرویس‌های من 📝'], ['text' => 'خرید سرویس جدید 🛒']], [['text' => 'پشتیبانی 📨']]], 'resize_keyboard' => true];

    switch ($text) {
        case '/start':
            if ($user) {
                $reply_text = "سلام " . htmlspecialchars($first_name) . "! خوش آمدید.\nشما با حساب کاربری `" . htmlspecialchars($user['username']) . "` متصل هستید.";
                create_api_response('sendMessage', ['chat_id' => $chat_id, 'text' => $reply_text, 'reply_markup' => json_encode($main_keyboard)]);
            } else {
                request_to_link_account($chat_id);
            }
            break;

        case 'موجودی کیف پول 💰':
            if ($user) {
                $reply_text = "موجودی کیف پول شما: `" . number_format($user['wallet_balance']) . "` تومان";
                create_api_response('sendMessage', ['chat_id' => $chat_id, 'text' => $reply_text, 'reply_markup' => json_encode($main_keyboard)]);
            } else {
                request_to_link_account($chat_id);
            }
            break;

        case 'سرویس‌های من 📝':
            if ($user) {
                $services_stmt = $pdo->prepare("SELECT o.marzban_username, p.name as plan_name FROM orders o JOIN plans p ON o.plan_id = p.id WHERE o.user_id = ? AND o.status = 'active' AND o.expiry_date > NOW()");
                $services_stmt->execute([$user['id']]);
                $services = $services_stmt->fetchAll(PDO::FETCH_ASSOC);
                if (empty($services)) {
                    create_api_response('sendMessage', ['chat_id' => $chat_id, 'text' => "شما در حال حاضر هیچ سرویس فعالی ندارید.", 'reply_markup' => json_encode($main_keyboard)]);
                } else {
                    $reply_text = "لیست سرویس‌های فعال شما:\n(برای مشاهده جزئیات، روی دکمه مربوطه کلیک کنید)";
                    $inline_keyboard = [];
                    foreach ($services as $service) {
                        $button_text = htmlspecialchars($service['plan_name']) . " (`" . htmlspecialchars($service['marzban_username']) . "`)";
                        $inline_keyboard[] = [['text' => $button_text, 'callback_data' => 'details_' . $service['marzban_username']]];
                    }
                    create_api_response('sendMessage', ['chat_id' => $chat_id, 'text' => $reply_text, 'reply_markup' => json_encode(['inline_keyboard' => $inline_keyboard])]);
                }
            } else {
                request_to_link_account($chat_id);
            }
            break;
            
        case 'خرید سرویس جدید 🛒':
            if ($user) {
                $plans_stmt = $pdo->query("SELECT * FROM plans WHERE is_active = 1 ORDER BY price ASC");
                $plans = $plans_stmt->fetchAll(PDO::FETCH_ASSOC);

                if (empty($plans)) {
                     create_api_response('sendMessage', ['chat_id' => $chat_id, 'text' => "متاسفانه در حال حاضر هیچ پلن فعالی برای خرید وجود ندارد.", 'reply_markup' => json_encode($main_keyboard)]);
                } else {
                    $reply_text = "لطفاً پلن مورد نظر خود را برای خرید انتخاب کنید:";
                    $inline_keyboard = [];
                    foreach ($plans as $plan) {
                        $button_text = htmlspecialchars($plan['name']) . " - " . number_format($plan['price']) . " تومان";
                        $inline_keyboard[] = [['text' => $button_text, 'callback_data' => 'buy_plan_' . $plan['id']]];
                    }
                    create_api_response('sendMessage', ['chat_id' => $chat_id, 'text' => $reply_text, 'reply_markup' => json_encode(['inline_keyboard' => $inline_keyboard])]);
                }
            } else {
                request_to_link_account($chat_id);
            }
            break;
            
        default:
            if($user){
                 create_api_response('sendMessage', ['chat_id' => $chat_id, 'text' => "دستور نامشخص است.", 'reply_markup' => json_encode($main_keyboard)]);
            } else {
                 request_to_link_account($chat_id);
            }
            break;
    }
}

exit;