<?php
require_once '../core/config.php'; 
require_once '../core/database.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin' || !isset($_GET['id'])) {
    header("Location: tickets.php");
    exit();
}

$admin_id = $_SESSION['user_id'];
$ticket_id = (int)$_GET['id'];

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['submit_reply'])) {
    $message = trim($_POST['message']);
    $new_status = $_POST['status'];
    if (!empty($message)) {
        $pdo->beginTransaction();
        try {
            $reply_stmt = $pdo->prepare("INSERT INTO ticket_replies (ticket_id, user_id, message) VALUES (?, ?, ?)");
            $reply_stmt->execute([$ticket_id, $admin_id, $message]);

            $update_stmt = $pdo->prepare("UPDATE tickets SET status = ?, last_updated = NOW() WHERE id = ?");
            $update_stmt->execute([$new_status, $ticket_id]);
            $pdo->commit();
            header("Location: view_ticket.php?id=" . $ticket_id);
            exit;
        } catch (Exception $e) { $pdo->rollBack(); $error_message = "خطایی در ارسال پاسخ رخ داد."; }
    }
}

$stmt = $pdo->prepare("SELECT t.*, u.username FROM tickets t JOIN users u ON t.user_id = u.id WHERE t.id = ?");
$stmt->execute([$ticket_id]);
$ticket = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$ticket) { header("Location: tickets.php"); exit(); }

$replies_stmt = $pdo->prepare("SELECT r.*, u.username, u.role FROM ticket_replies r JOIN users u ON r.user_id = u.id WHERE r.ticket_id = ? ORDER BY r.created_at ASC");
$replies_stmt->execute([$ticket_id]);
$replies = $replies_stmt->fetchAll(PDO::FETCH_ASSOC);

// ... (آرایه‌های کمکی map بدون تغییر) ...

include 'includes/header.php';
include 'includes/sidebar.php'; 
?>

<main id="main-content" class="flex-1 p-6 mr-64 transition-all duration-300">
    <div class="mb-6">
        <h1 class="text-2xl font-bold text-gray-800">مشاهده تیکت #<?= $ticket['id'] ?> - کاربر: <?= htmlspecialchars($ticket['username']) ?></h1>
        <p class="text-gray-600 mt-1"><?= htmlspecialchars($ticket['subject']) ?></p>
    </div>

    <div class="bg-white rounded-lg shadow-sm p-6">
        <div class="space-y-6 max-h-[60vh] overflow-y-auto pr-2">
            <?php foreach($replies as $reply): ?>
                <?php if($reply['role'] === 'admin'): // پیام‌های ادمین ?>
                    <div class="flex flex-col items-start">
                        <div class="bg-gray-100 p-4 rounded-lg rounded-bl-none max-w-xl">
                            <p class="text-gray-800"><?= nl2br(htmlspecialchars($reply['message'])) ?></p>
                        </div>
                        <div class="text-xs text-gray-400 mt-1">پشتیبانی (<?= htmlspecialchars($reply['username']) ?>) در <?= date("Y/m/d H:i", strtotime($reply['created_at'])) ?></div>
                    </div>
                <?php else: // پیام‌های کاربر ?>
                    <div class="flex flex-col items-end">
                        <div class="bg-blue-500 text-white p-4 rounded-lg rounded-br-none max-w-xl">
                            <p><?= nl2br(htmlspecialchars($reply['message'])) ?></p>
                        </div>
                        <div class="text-xs text-gray-400 mt-1">کاربر در <?= date("Y/m/d H:i", strtotime($reply['created_at'])) ?></div>
                    </div>
                <?php endif; ?>
            <?php endforeach; ?>
        </div>

        <div class="border-t mt-6 pt-6">
            <h3 class="text-lg font-semibold text-gray-800 mb-2">ارسال پاسخ</h3>
            <form action="view_ticket.php?id=<?= $ticket_id ?>" method="POST">
                <div>
                    <textarea name="message" rows="5" class="w-full bg-white rounded-lg border border-gray-300 focus:border-primary focus:ring-1 focus:ring-primary/50 transition" required></textarea>
                </div>
                <div class="mt-4 flex items-center justify-between">
                    <div>
                        <label for="status" class="text-sm font-medium text-gray-700">تغییر وضعیت به:</label>
                        <select name="status" id="status" class="mt-1 rounded-lg border-gray-300">
                            <option value="answered" <?= $ticket['status'] == 'answered' ? 'selected' : '' ?>>پاسخ داده شده</option>
                            <option value="open" <?= $ticket['status'] == 'open' ? 'selected' : '' ?>>باز</option>
                            <option value="customer-reply" <?= $ticket['status'] == 'customer-reply' ? 'selected' : '' ?>>پاسخ مشتری</option>
                            <option value="closed" <?= $ticket['status'] == 'closed' ? 'selected' : '' ?>>بستن تیکت</option>
                        </select>
                    </div>
                    <button type="submit" name="submit_reply" class="bg-primary text-white px-6 py-2 rounded-lg hover:bg-primary/90">ارسال پاسخ</button>
                </div>
            </form>
        </div>
    </div>
</main>

<?php include 'includes/footer.php'; ?>