<?php
require_once '../core/config.php';
require_once '../core/database.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    header("Location: ../login.php");
    exit();
}

/**
 * تابع کمکی برای ذخیره یا آپدیت یک تنظیم در دیتابیس
 */
function save_setting_value($key, $value) {
    global $pdo;
    // این کوئری اگر کلید وجود داشته باشد آپدیت و اگر نداشته باشد، آن را ایجاد می‌کند
    $stmt = $pdo->prepare(
        "INSERT INTO settings (setting_key, setting_value) VALUES (:key, :value)
         ON DUPLICATE KEY UPDATE setting_value = :value"
    );
    $stmt->execute(['key' => $key, 'value' => $value]);
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        // حالت اول: دکمه اصلی "ذخیره تنظیمات" فشرده شده است
        if (isset($_POST['save_settings'])) {
            save_setting_value('telegram_main_bot_token', trim($_POST['telegram_main_bot_token'] ?? ''));
            save_setting_value('telegram_admin_chat_id', trim($_POST['telegram_admin_chat_id'] ?? ''));

            // اگر کلید امنیتی API هنوز ساخته نشده، یکی بساز
            if (empty(setting('api_secret_key'))) {
                save_setting_value('api_secret_key', bin2hex(random_bytes(32)));
            }
            $_SESSION['flash_message'] = 'تنظیمات ربات با موفقیت ذخیره شد.';
        }
        // حالت دوم: دکمه "تولید کلید جدید" فشرده شده است
        elseif (isset($_POST['regenerate_api_key'])) {
            save_setting_value('api_secret_key', bin2hex(random_bytes(32)));
            $_SESSION['flash_message'] = 'کلید امنیتی جدید با موفقیت ساخته شد.';
        }

        $_SESSION['flash_message_type'] = 'success';

    } catch (Exception $e) {
        $_SESSION['flash_message'] = 'خطا: ' . $e->getMessage();
        $_SESSION['flash_message_type'] = 'error';
    }
    header("Location: settings-bot.php");
    exit;
}

$message_html = '';
if (isset($_SESSION['flash_message'])) {
    $message_type_class = ($_SESSION['flash_message_type'] ?? 'success') === 'success' ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800';
    $message_html = '<div class="mb-4 p-4 rounded-lg ' . $message_type_class . '">' . htmlspecialchars($_SESSION['flash_message']) . '</div>';
    unset($_SESSION['flash_message'], $_SESSION['flash_message_type']);
}

include 'includes/header.php';
include 'includes/sidebar.php';
?>

<main id="main-content" class="flex-1 p-6 mr-64 transition-all duration-300">
    <div class="mb-8">
        <h1 class="text-2xl font-bold text-gray-800">تنظیمات ربات تلگرام</h1>
        <p class="text-gray-600 mt-1">اطلاعات ربات اصلی پلتفرم را در اینجا وارد کنید.</p>
    </div>

    <?= $message_html ?>

    <div class="bg-white rounded-lg shadow-sm">
        <form action="settings-bot.php" method="POST">
            <div class="p-6 space-y-6">
                <h3 class="text-lg font-semibold text-gray-800 border-b pb-3">اتصال ربات</h3>
                <div>
                    <label for="telegram_main_bot_token" class="block text-sm font-medium text-gray-700">توکن API ربات اصلی</label>
                    <input type="text" name="telegram_main_bot_token" id="telegram_main_bot_token" value="<?= htmlspecialchars(setting('telegram_main_bot_token', '')) ?>" class="mt-1 block w-full bg-white rounded-lg border border-gray-300 focus:border-primary focus:ring-1 focus:ring-primary/50 transition text-left" style="direction: ltr;" placeholder="توکن دریافت شده از BotFather">
                </div>
                <div>
                    <label for="telegram_admin_chat_id" class="block text-sm font-medium text-gray-700">شناسه عددی تلگرام مدیر</label>
                    <input type="text" name="telegram_admin_chat_id" id="telegram_admin_chat_id" value="<?= htmlspecialchars(setting('telegram_admin_chat_id', '')) ?>" class="mt-1 block w-full bg-white rounded-lg border border-gray-300 focus:border-primary focus:ring-1 focus:ring-primary/50 transition text-left" style="direction: ltr;">
                    <p class="text-xs text-gray-500 mt-1">برای دریافت شناسه، به ربات <a href="https://t.me/userinfobot" target="_blank" class="text-primary hover:underline">@userinfobot</a> پیام دهید.</p>
                </div>
            </div>
            <div class="p-6 bg-gray-50 flex justify-end">
                <button type="submit" name="save_settings" class="bg-primary text-white px-6 py-2 rounded-lg hover:bg-primary/90">ذخیره تنظیمات</button>
            </div>
        </form>
    </div>

    <div class="bg-white rounded-lg shadow-sm mt-8">
        <div class="p-6">
            <h3 class="text-lg font-semibold text-gray-800">کلید امنیتی ارتباط (API Secret Key)</h3>
            <p class="text-sm text-gray-500 mt-2">این کلید برای ارتباط امن بین اسکریپت ربات و پنل شما استفاده می‌شود.</p>
            <div class="relative mt-4">
                <input type="text" readonly value="<?= htmlspecialchars(setting('api_secret_key', 'ابتدا یکبار تنظیمات را ذخیره کنید تا ساخته شود')) ?>" class="w-full bg-gray-100 rounded-lg p-3 text-gray-600 font-mono text-left" style="direction: ltr;">
            </div>
        </div>
        <div class="p-6 bg-gray-50 flex justify-end">
            <form action="settings-bot.php" method="POST" onsubmit="return confirm('آیا از ساخت کلید جدید مطمئن هستید؟ کلید فعلی غیرفعال خواهد شد.')">
                <button type="submit" name="regenerate_api_key" class="bg-yellow-500 text-white px-6 py-2 rounded-lg hover:bg-yellow-600">تولید کلید جدید</button>
            </form>
        </div>
    </div>
</main>
<?php include 'includes/footer.php'; ?>