<?php
require_once '../core/config.php';
require_once '../core/database.php';

// تاریخ پیش‌فرض: ۳۰ روز گذشته
$start_date = $_GET['start_date'] ?? date('Y-m-d', strtotime('-30 days'));
$end_date = $_GET['end_date'] ?? date('Y-m-d');

$sql_base = "FROM orders o JOIN users u ON o.user_id = u.id JOIN plans p ON o.plan_id = p.id";
$where_clause = "WHERE o.order_date BETWEEN ? AND ?";
$params = [$start_date . ' 00:00:00', $end_date . ' 23:59:59'];

// دریافت آمار کلی برای بازه زمانی انتخاب شده
$stats_stmt = $pdo->prepare("SELECT COUNT(*) as order_count, SUM(o.price) as total_revenue $sql_base $where_clause");
$stats_stmt->execute($params);
$stats = $stats_stmt->fetch(PDO::FETCH_ASSOC);

// دریافت لیست سفارشات برای نمایش در جدول
$orders_stmt = $pdo->prepare("SELECT o.*, u.username, p.name as plan_name $sql_base $where_clause ORDER BY o.order_date DESC");
$orders_stmt->execute($params);
$orders = $orders_stmt->fetchAll(PDO::FETCH_ASSOC);

include 'includes/header.php';
include 'includes/sidebar.php';
?>

<main id="main-content" class="flex-1 p-6 mr-64 transition-all duration-300">
    <div class="mb-8">
        <h1 class="text-2xl font-bold text-gray-800">گزارش فروش</h1>
        <p class="text-gray-600 mt-1">درآمد و تعداد سفارشات را در بازه‌های زمانی دلخواه بررسی کنید.</p>
    </div>

    <div class="bg-white p-4 rounded-lg shadow-sm mb-6">
        <form action="report-sales.php" method="GET" class="grid grid-cols-1 md:grid-cols-3 gap-4">
            <div>
                <label for="start_date" class="text-sm font-medium text-gray-700">از تاریخ</label>
                <input type="date" name="start_date" id="start_date" value="<?= htmlspecialchars($start_date) ?>" class="mt-1 w-full bg-gray-50 rounded-lg border-gray-300 text-sm" style="direction: ltr; text-align: right;">
            </div>
            <div>
                <label for="end_date" class="text-sm font-medium text-gray-700">تا تاریخ</label>
                <input type="date" name="end_date" id="end_date" value="<?= htmlspecialchars($end_date) ?>" class="mt-1 w-full bg-gray-50 rounded-lg border-gray-300 text-sm" style="direction: ltr; text-align: right;">
            </div>
            <div class="flex items-end">
                <button type="submit" class="w-full bg-primary text-white py-2 px-4 rounded-lg hover:bg-primary/90">نمایش گزارش</button>
            </div>
        </form>
    </div>

    <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
        <div class="bg-green-50 p-6 rounded-lg shadow-sm">
            <p class="text-green-800">مجموع درآمد</p>
            <p class="text-3xl font-bold text-green-900 mt-1"><?= number_format($stats['total_revenue'] ?? 0) ?> <span class="text-lg">تومان</span></p>
        </div>
        <div class="bg-blue-50 p-6 rounded-lg shadow-sm">
            <p class="text-blue-800">تعداد کل سفارشات</p>
            <p class="text-3xl font-bold text-blue-900 mt-1"><?= number_format($stats['order_count'] ?? 0) ?></p>
        </div>
    </div>

    <div class="bg-white rounded-lg shadow-sm p-6">
        <h3 class="font-semibold text-gray-800 mb-4">لیست سفارشات در بازه انتخابی</h3>
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead>
                    <tr class="border-b-2 border-gray-200">
                        <th class="text-right py-3 px-4 text-sm font-medium text-gray-500">کاربر</th>
                        <th class="text-right py-3 px-4 text-sm font-medium text-gray-500">پلن</th>
                        <th class="text-right py-3 px-4 text-sm font-medium text-gray-500">مبلغ</th>
                        <th class="text-right py-3 px-4 text-sm font-medium text-gray-500">تاریخ سفارش</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (empty($orders)): ?>
                        <tr><td colspan="4" class="text-center py-6 text-gray-500">هیچ سفارشی در این بازه زمانی یافت نشد.</td></tr>
                    <?php else: ?>
                        <?php foreach ($orders as $order): ?>
                            <tr class="border-b border-gray-100 hover:bg-gray-50">
                                <td class="py-3 px-4 font-semibold"><?= htmlspecialchars($order['username']) ?></td>
                                <td class="py-3 px-4"><?= htmlspecialchars($order['plan_name']) ?></td>
                                <td class="py-3 px-4 font-mono"><?= number_format($order['price']) ?> ت</td>
                                <td class="py-3 px-4 text-gray-500"><?= date("Y/m/d H:i", strtotime($order['order_date'])) ?></td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</main>

<?php include 'includes/footer.php'; ?>