<?php
require_once '../core/config.php';
require_once '../core/database.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: ../login.php");
    exit();
}

$user_id = $_SESSION['user_id'];
$message = '';
$message_type = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $current_password = $_POST['current_password'];
    $new_password = $_POST['new_password'];
    $confirm_password = $_POST['confirm_password'];

    if (empty($current_password) || empty($new_password) || empty($confirm_password)) {
        $message = 'تمام فیلدها الزامی هستند.';
        $message_type = 'error';
    } elseif ($new_password !== $confirm_password) {
        $message = 'رمز عبور جدید و تکرار آن یکسان نیستند.';
        $message_type = 'error';
    } elseif (strlen($new_password) < 6) {
        $message = 'رمز عبور جدید باید حداقل ۶ کاراکتر باشد.';
        $message_type = 'error';
    } else {
        $stmt = $pdo->prepare("SELECT password FROM users WHERE id = ?");
        $stmt->execute([$user_id]);
        $user = $stmt->fetch();

        if ($user && password_verify($current_password, $user['password'])) {
            $new_hashed_password = password_hash($new_password, PASSWORD_DEFAULT);
            $update_stmt = $pdo->prepare("UPDATE users SET password = ? WHERE id = ?");
            if ($update_stmt->execute([$new_hashed_password, $user_id])) {
                $message = 'رمز عبور با موفقیت تغییر کرد.';
                $message_type = 'success';
            } else {
                $message = 'خطایی در بروزرسانی رمز عبور رخ داد.';
                $message_type = 'error';
            }
        } else {
            $message = 'رمز عبور فعلی شما صحیح نمی‌باشد.';
            $message_type = 'error';
        }
    }
}

include 'includes/header.php';
include 'includes/sidebar.php';
?>

<main id="main-content" class="flex-1 p-6 mr-64 transition-all duration-300">
    <div class="mb-8">
        <h1 class="text-2xl font-bold text-gray-800">پروفایل کاربری و تغییر رمز عبور</h1>
    </div>

    <?php if ($message): ?>
        <div class="mb-4 p-4 rounded-lg <?= $message_type === 'success' ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' ?>">
            <?= htmlspecialchars($message) ?>
        </div>
    <?php endif; ?>

    <div class="bg-white rounded-lg shadow-sm p-6 max-w-lg mx-auto">
        <form action="profile.php" method="POST">
            <div class="space-y-4">
                <div>
                    <label for="current_password" class="block text-sm font-medium text-gray-700">رمز عبور فعلی</label>
                    <input type="password" name="current_password" id="current_password" class="mt-1 w-full bg-gray-50 rounded-lg border-gray-300" required>
                </div>
                <div>
                    <label for="new_password" class="block text-sm font-medium text-gray-700">رمز عبور جدید</label>
                    <input type="password" name="new_password" id="new_password" class="mt-1 w-full bg-gray-50 rounded-lg border-gray-300" required>
                </div>
                <div>
                    <label for="confirm_password" class="block text-sm font-medium text-gray-700">تکرار رمز عبور جدید</label>
                    <input type="password" name="confirm_password" id="confirm_password" class="mt-1 w-full bg-gray-50 rounded-lg border-gray-300" required>
                </div>
            </div>
            <div class="mt-6">
                <button type="submit" class="w-full bg-primary text-white py-2.5 rounded-lg font-semibold hover:bg-primary/90">
                    تغییر رمز عبور
                </button>
            </div>
        </form>
    </div>
</main>

<?php include 'includes/footer.php'; ?>