<?php
require_once '../core/config.php';
require_once '../core/database.php';
use App\MarzbanAPI;

$message = '';
$message_type = '';

if (isset($_SESSION['flash_message'])) {
    $message = $_SESSION['flash_message'];
    $message_type = $_SESSION['flash_message_type'] ?? 'success';
    unset($_SESSION['flash_message'], $_SESSION['flash_message_type']);
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $api = new MarzbanAPI();
    $redirect_url = $_SERVER['REQUEST_URI'];
    $admin_id = $_SESSION['user_id'];

    if (isset($_POST['action']) && $_POST['action'] === 'add_to_service') {
        $order_id = $_POST['order_id'];
        $marzban_username = $_POST['marzban_username'];
        $add_days = (int)($_POST['add_days'] ?? 0);
        $add_gb = (int)($_POST['add_gb'] ?? 0);

        if ($add_days > 0 || $add_gb > 0) {
            $result = $api->add_to_service($marzban_username, $add_days, $add_gb);
            if (isset($result['username'])) {
                $new_expiry_date = date('Y-m-d H:i:s', $result['expire']);
                $pdo->prepare("UPDATE orders SET expiry_date = ? WHERE id = ?")->execute([$new_expiry_date, $order_id]);
                $_SESSION['flash_message'] = "تغییرات با موفقیت بر روی سرویس اعمال شد.";
                $_SESSION['flash_message_type'] = 'success';
            } else {
                $_SESSION['flash_message'] = "خطا در ویرایش سرویس: " . ($result['error'] ?? 'خطای نامشخص');
                $_SESSION['flash_message_type'] = 'error';
            }
        }
        header("Location: " . $redirect_url);
        exit;
    }

    if (isset($_POST['action']) && $_POST['action'] === 'delete_service') {
        $username_to_delete = $_POST['marzban_username'];
        $order_id_to_modify = $_POST['order_id'];
        $result = $api->deleteUser($username_to_delete);
        if ($result === true || (isset($result['error']) && str_contains($result['error'], 'User not found'))) {
            $pdo->prepare("UPDATE orders SET status = 'terminated', terminated_at = NOW(), terminated_by = ? WHERE id = ?")->execute([$admin_id, $order_id_to_modify]);
            $_SESSION['flash_message'] = "سرویس " . htmlspecialchars($username_to_delete) . " خاتمه یافت.";
            $_SESSION['flash_message_type'] = 'success';
        } else {
            $_SESSION['flash_message'] = "خطا در حذف سرویس از مرزبان: " . ($result['error'] ?? 'خطای نامشخص');
            $_SESSION['flash_message_type'] = 'error';
        }
        header("Location: " . $redirect_url);
        exit;
    }

    if (isset($_POST['action']) && $_POST['action'] === 'modify_status') {
        $username_to_modify = $_POST['marzban_username'];
        $order_id_to_modify = $_POST['order_id'];
        $new_status = $_POST['new_status'];
        $result = $api->modifyUser($username_to_modify, ['status' => $new_status]);
        if (isset($result['username'])) {
            $pdo->prepare("UPDATE orders SET status = ? WHERE id = ?")->execute([$new_status, $order_id_to_modify]);
            $_SESSION['flash_message'] = "وضعیت سرویس " . htmlspecialchars($username_to_modify) . " با موفقیت تغییر کرد.";
            $_SESSION['flash_message_type'] = 'success';
        } else {
            $_SESSION['flash_message'] = "خطا در تغییر وضعیت سرویس: " . ($result['error'] ?? 'خطای نامشخص');
            $_SESSION['flash_message_type'] = 'error';
        }
        header("Location: " . $redirect_url);
        exit;
    }

    if (isset($_POST['create_service'])) {
        $user_id = $_POST['user_id'];
        $plan_id = $_POST['plan_id'];
        if (empty($user_id) || empty($plan_id)) {
            $message = 'لطفاً هم کاربر و هم پلن را انتخاب کنید.';
            $message_type = 'error';
        } else {
            $plan_stmt = $pdo->prepare("SELECT * FROM plans WHERE id = ?");
            $plan_stmt->execute([$plan_id]);
            $plan = $plan_stmt->fetch(PDO::FETCH_ASSOC);
            if ($plan) {
                $marzban_username = setting('marzban_user_prefix', 'user_') . substr(uniqid(), 7);
                $on_hold_status = ($plan['on_hold_enabled'] == 1);
                $marzban_response = $api->createUser($marzban_username, (int)$plan['traffic_gb'], (int)$plan['duration_days'], $on_hold_status);
                if (isset($marzban_response['username'])) {
                    $sub_link = $marzban_response['subscription_url'] ?? 'لینک یافت نشد';
                    $expiry_date_db = ($plan['duration_days'] > 0) ? date('Y-m-d H:i:s', time() + ((int)$plan['duration_days'] * 86400)) : null;
                    $order_stmt = $pdo->prepare("INSERT INTO orders (user_id, plan_id, marzban_username, sub_link, price, expiry_date, status) VALUES (?, ?, ?, ?, ?, ?, 'active')");
                    $order_stmt->execute([$user_id, $plan_id, $marzban_username, $sub_link, $plan['price'], $expiry_date_db]);
                    $message = "سرویس با موفقیت برای کاربر ایجاد شد!";
                    $message_type = 'success';
                } else {
                    $message = "خطا در ایجاد سرویس: " . ($marzban_response['error'] ?? 'پاسخ نامعتبر');
                    $message_type = 'error';
                }
            } else {
                $message = 'خطا: پلن انتخاب شده معتبر نیست.';
                $message_type = 'error';
            }
        }
    }
}


$filter_role = $_GET['filter_role'] ?? 'all';
$search_term = trim($_GET['search'] ?? '');
$start_date = $_GET['start_date'] ?? '';
$end_date = $_GET['end_date'] ?? '';

$sql = "SELECT o.*, u.username as platform_username, p.name as plan_name, terminator.username as terminator_username 
        FROM orders o
        JOIN users u ON o.user_id = u.id
        JOIN plans p ON o.plan_id = p.id
        LEFT JOIN users terminator ON o.terminated_by = terminator.id";
$where_conditions = [];
$params = [];

if (in_array($filter_role, ['user', 'reseller'])) { $where_conditions[] = "u.role = ?"; $params[] = $filter_role; }
if (!empty($search_term)) { $where_conditions[] = "(u.username LIKE ? OR o.marzban_username LIKE ? OR p.name LIKE ?)"; $like_term = "%{$search_term}%"; $params[] = $like_term; $params[] = $like_term; $params[] = $like_term; }
if (!empty($start_date)) { $where_conditions[] = "o.order_date >= ?"; $params[] = $start_date; }
if (!empty($end_date)) { $where_conditions[] = "DATE(o.order_date) <= ?"; $params[] = $end_date; }

if (!empty($where_conditions)) { $sql .= " WHERE " . implode(' AND ', $where_conditions); }
$sql .= " ORDER BY o.order_date DESC";

$orders_stmt = $pdo->prepare($sql);
$orders_stmt->execute($params);
$orders = $orders_stmt->fetchAll(PDO::FETCH_ASSOC);

$users = $pdo->query("SELECT id, username FROM users WHERE role != 'admin' ORDER BY username")->fetchAll(PDO::FETCH_ASSOC);
$plans = $pdo->query("SELECT id, name FROM plans WHERE is_active = 1 ORDER BY name")->fetchAll(PDO::FETCH_ASSOC);

include 'includes/header.php';
include 'includes/sidebar.php';
?>

<main id="main-content" class="flex-1 p-6 mr-64 transition-all duration-300">
    <div class="flex justify-between items-center mb-6">
        <h1 class="text-2xl font-bold text-gray-800">مدیریت سفارشات</h1>
        <button id="add-order-btn" class="bg-primary text-white px-5 py-2 rounded-lg hover:bg-primary/90 transition-colors flex items-center space-x-2 space-x-reverse">
            <i class="ri-add-line"></i>
            <span>ایجاد سرویس دستی</span>
        </button>
    </div>

    <div class="bg-white p-4 rounded-lg shadow-sm mb-6">
        <form action="orders.php" method="GET" class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">
            <input type="hidden" name="filter_role" value="<?= htmlspecialchars($filter_role) ?>">
            <div><label for="search" class="text-sm font-medium text-gray-700">جستجو</label><input type="text" name="search" id="search" value="<?= htmlspecialchars($search_term) ?>" placeholder="نام کاربری، پلن و..." class="mt-1 w-full bg-gray-50 rounded-lg border-gray-300 text-sm"></div>
            <div><label for="start_date" class="text-sm font-medium text-gray-700">از تاریخ</label><input type="date" name="start_date" id="start_date" value="<?= htmlspecialchars($start_date) ?>" class="mt-1 w-full bg-gray-50 rounded-lg border-gray-300 text-sm" style="direction: ltr; text-align: right;"></div>
            <div><label for="end_date" class="text-sm font-medium text-gray-700">تا تاریخ</label><input type="date" name="end_date" id="end_date" value="<?= htmlspecialchars($end_date) ?>" class="mt-1 w-full bg-gray-50 rounded-lg border-gray-300 text-sm" style="direction: ltr; text-align: right;"></div>
            <div class="flex items-end space-x-2 space-x-reverse"><button type="submit" class="w-full bg-primary text-white py-2 px-4 rounded-lg hover:bg-primary/90">فیلتر</button><a href="orders.php" class="w-full text-center bg-gray-200 text-gray-800 py-2 px-4 rounded-lg hover:bg-gray-300">حذف فیلتر</a></div>
        </form>
    </div>

    <div class="mb-6">
        <div class="flex border-b border-gray-200">
            <?php $query_params = array_filter(['search' => $search_term, 'start_date' => $start_date, 'end_date' => $end_date]); ?>
            <a href="orders.php?filter_role=all&<?= http_build_query($query_params) ?>" class="px-4 py-2 text-sm font-medium <?= $filter_role === 'all' ? 'border-b-2 border-primary text-primary' : 'text-gray-500 hover:text-gray-700' ?>">همه سفارشات</a>
            <a href="orders.php?filter_role=user&<?= http_build_query($query_params) ?>" class="px-4 py-2 text-sm font-medium <?= $filter_role === 'user' ? 'border-b-2 border-primary text-primary' : 'text-gray-500 hover:text-gray-700' ?>">سفارشات کاربران</a>
            <a href="orders.php?filter_role=reseller&<?= http_build_query($query_params) ?>" class="px-4 py-2 text-sm font-medium <?= $filter_role === 'reseller' ? 'border-b-2 border-primary text-primary' : 'text-gray-500 hover:text-gray-700' ?>">سفارشات نماینده ها</a>
        </div>
    </div>

    <?php if ($message): ?>
        <div class="mb-4 p-4 rounded-lg <?= $message_type === 'success' ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' ?>"><?= htmlspecialchars($message) ?></div>
    <?php endif; ?>

    <div class="bg-white rounded-lg shadow-sm p-6">
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead>
                    <tr class="border-b-2 border-gray-200">
                        <th class="text-right py-3 px-4 text-sm font-medium text-gray-500">کاربر</th>
                        <th class="text-right py-3 px-4 text-sm font-medium text-gray-500">نام کاربری مرزبان</th>
                        <th class="text-right py-3 px-4 text-sm font-medium text-gray-500">تاریخ انقضا</th>
                        <th class="text-right py-3 px-4 text-sm font-medium text-gray-500">وضعیت</th>
                        <th class="text-right py-3 px-4 text-sm font-medium text-gray-500">جزئیات خاتمه</th>
                        <th class="text-center py-3 px-4 text-sm font-medium text-gray-500">عملیات</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (empty($orders)): ?>
                        <tr><td colspan="6" class="text-center py-6 text-gray-500">هیچ سفارشی با این مشخصات یافت نشد.</td></tr>
                    <?php else: ?>
                        <?php foreach ($orders as $order): ?>
                            <tr class="border-b border-gray-100 hover:bg-gray-50">
                                <td class="py-3 px-4 text-sm font-bold"><?= htmlspecialchars($order['platform_username']) ?></td>
                                <td class="py-3 px-4 text-sm font-mono"><?= htmlspecialchars($order['marzban_username']) ?></td>
                                <td class="py-3 px-4 text-sm"><?= $order['expiry_date'] ? date("Y/m/d", strtotime($order['expiry_date'])) : 'نامحدود' ?></td>
                                <td class="py-3 px-4 text-sm">
                                    <?php $status_map = ['active' => ['text' => 'فعال', 'class' => 'bg-green-100 text-green-800'],'disabled' => ['text' => 'غیرفعال', 'class' => 'bg-yellow-100 text-yellow-800'],'expired' => ['text' => 'منقضی', 'class' => 'bg-red-100 text-red-800'],'terminated' => ['text' => 'خاتمه یافته', 'class' => 'bg-gray-200 text-gray-800'],'cancelled' => ['text' => 'لغو شده', 'class' => 'bg-gray-200 text-gray-800']]; $status_info = $status_map[$order['status']] ?? ['text' => htmlspecialchars($order['status']), 'class' => 'bg-gray-200 text-gray-800']; ?><span class="px-2 py-1 text-xs rounded-full <?= $status_info['class'] ?>"><?= $status_info['text'] ?></span>
                                </td>
                                <td class="py-3 px-4 text-xs text-gray-500">
                                    <?php if ($order['status'] === 'terminated' && !empty($order['terminated_at'])): ?>
                                        <div class="flex flex-col"><span>توسط: <?= htmlspecialchars($order['terminator_username'] ?? 'سیستم') ?></span><span><?= date("Y/m/d", strtotime($order['terminated_at'])) ?></span></div>
                                    <?php else: ?><span class="text-gray-400">—</span><?php endif; ?>
                                </td>
                                <td class="py-3 px-4 text-center">
                                    <div class="flex items-center justify-center gap-x-1">
                                        <?php if(in_array($order['status'], ['active', 'disabled'])): ?>
                                            <button type="button" class="edit-service-btn w-8 h-8 flex items-center justify-center text-indigo-500 hover:bg-indigo-50 rounded-lg" data-order-id="<?= $order['id'] ?>" data-username="<?= htmlspecialchars($order['marzban_username']) ?>" title="افزودن روز/حجم"><i class="ri-edit-2-line ri-lg"></i></button>
                                            <?php if ($order['status'] === 'active'): ?>
                                                <form action="<?= htmlspecialchars($_SERVER['REQUEST_URI']) ?>" method="POST" class="flex"><input type="hidden" name="action" value="modify_status"><input type="hidden" name="order_id" value="<?= $order['id'] ?>"><input type="hidden" name="marzban_username" value="<?= $order['marzban_username'] ?>"><input type="hidden" name="new_status" value="disabled"><button type="submit" title="غیرفعال کردن" class="w-8 h-8 flex items-center justify-center text-yellow-500 hover:bg-yellow-50 rounded-lg transition-colors"><i class="ri-pause-circle-line ri-lg"></i></button></form>
                                            <?php else: ?>
                                                 <form action="<?= htmlspecialchars($_SERVER['REQUEST_URI']) ?>" method="POST" class="flex"><input type="hidden" name="action" value="modify_status"><input type="hidden" name="order_id" value="<?= $order['id'] ?>"><input type="hidden" name="marzban_username" value="<?= $order['marzban_username'] ?>"><input type="hidden" name="new_status" value="active"><button type="submit" title="فعال کردن" class="w-8 h-8 flex items-center justify-center text-green-500 hover:bg-green-50 rounded-lg transition-colors"><i class="ri-play-circle-line ri-lg"></i></button></form>
                                            <?php endif; ?>
                                            <form action="<?= htmlspecialchars($_SERVER['REQUEST_URI']) ?>" method="POST" class="flex" onsubmit="return confirm('آیا از حذف این سرویس از پنل مرزبان و خاتمه دادن به آن مطمئن هستید؟');"><input type="hidden" name="action" value="delete_service"><input type="hidden" name="order_id" value="<?= $order['id'] ?>"><input type="hidden" name="marzban_username" value="<?= $order['marzban_username'] ?>"><button type="submit" title="حذف سرویس" class="w-8 h-8 flex items-center justify-center text-red-500 hover:bg-red-50 rounded-lg transition-colors"><i class="ri-delete-bin-line ri-lg"></i></button></form>
                                        <?php else: ?>
                                            <span class="text-gray-400 text-xs">—</span>
                                        <?php endif; ?>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</main>

<div id="order-modal" class="hidden fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center z-50 p-4">
    <div class="bg-white rounded-lg shadow-xl p-6 w-full max-w-lg mx-4">
        <div class="flex justify-between items-center border-b pb-3 mb-4">
            <h2 class="text-xl font-semibold text-gray-800">ایجاد سرویس دستی</h2>
            <button id="close-modal-btn" class="text-gray-500 hover:text-gray-800"><i class="ri-close-line ri-lg"></i></button>
        </div>
        <form action="<?= htmlspecialchars($_SERVER['REQUEST_URI']) ?>" method="POST">
            <div class="space-y-4">
                <div>
                    <label for="user_id" class="block text-sm font-medium text-gray-700">انتخاب کاربر</label>
                    <select id="user_id" name="user_id" class="mt-1 w-full bg-gray-50 rounded-lg border-gray-300" required>
                        <option value="">-- یک کاربر را انتخاب کنید --</option>
                        <?php foreach($users as $user): ?><option value="<?= $user['id'] ?>"><?= htmlspecialchars($user['username']) ?></option><?php endforeach; ?>
                    </select>
                </div>
                <div>
                    <label for="plan_id" class="block text-sm font-medium text-gray-700">انتخاب پلن</label>
                    <select id="plan_id" name="plan_id" class="mt-1 w-full bg-gray-50 rounded-lg border-gray-300" required>
                        <option value="">-- یک پلن را انتخاب کنید --</option>
                        <?php foreach($plans as $plan): ?><option value="<?= $plan['id'] ?>"><?= htmlspecialchars($plan['name']) ?></option><?php endforeach; ?>
                    </select>
                </div>
            </div>
            <div class="mt-6 flex items-center justify-end space-x-4 space-x-reverse">
                <button type="button" id="cancel-btn" class="bg-gray-200 text-gray-800 px-5 py-2 rounded-lg hover:bg-gray-300">لغو</button>
                <button type="submit" name="create_service" class="bg-primary text-white px-5 py-2 rounded-lg hover:bg-primary/90">ایجاد سرویس</button>
            </div>
        </form>
    </div>
</div>

<div id="edit-service-modal" class="hidden fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center z-50 p-4">
    <div class="bg-white rounded-lg shadow-xl p-6 w-full max-w-md">
        <div class="flex justify-between items-center border-b pb-3 mb-4"><h2 class="text-xl font-semibold">افزودن روز/حجم به سرویس</h2><button id="close-edit-modal-btn" class="text-gray-500"><i class="ri-close-line ri-lg"></i></button></div>
        <form id="edit-service-form" action="<?= htmlspecialchars($_SERVER['REQUEST_URI']) ?>" method="POST">
            <input type="hidden" name="action" value="add_to_service"><input type="hidden" name="order_id" id="edit_order_id"><input type="hidden" name="marzban_username" id="edit_marzban_username">
            <p class="text-sm mb-4">به سرویس <strong id="username_to_edit" class="font-mono"></strong></p>
            <div class="space-y-4">
                <div><label for="add_days" class="block text-sm font-medium text-gray-700">تعداد روز برای افزودن</label><input type="number" name="add_days" id="add_days" value="0" min="0" class="mt-1 w-full bg-gray-50 rounded-lg border-gray-300"></div>
                <div><label for="add_gb" class="block text-sm font-medium text-gray-700">مقدار حجم برای افزودن (GB)</label><input type="number" name="add_gb" id="add_gb" value="0" min="0" class="mt-1 w-full bg-gray-50 rounded-lg border-gray-300"></div>
            </div>
            <div class="mt-6 flex justify-end"><button type="submit" class="bg-primary text-white px-6 py-2 rounded-lg">اعمال تغییرات</button></div>
        </form>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const orderModal = document.getElementById('order-modal');
    const addOrderBtn = document.getElementById('add-order-btn');
    if (addOrderBtn) {
        const closeOrderModalBtn = orderModal.querySelector('#close-modal-btn');
        const cancelOrderBtn = orderModal.querySelector('#cancel-btn');
        const openModal = () => orderModal.classList.remove('hidden');
        const closeModal = () => orderModal.classList.add('hidden');
        addOrderBtn.addEventListener('click', openModal);
        closeOrderModalBtn.addEventListener('click', closeModal);
        cancelOrderBtn.addEventListener('click', closeModal);
        orderModal.addEventListener('click', (e) => {
            if (e.target === orderModal) closeModal();
        });
        <?php if (($message_type ?? '') === 'error' && isset($_POST['create_service'])): ?>
            openModal();
        <?php endif; ?>
    }

    const editModal = document.getElementById('edit-service-modal');
    if (editModal) {
        const closeEditBtn = document.getElementById('close-edit-modal-btn');
        document.querySelectorAll('.edit-service-btn').forEach(button => {
            button.addEventListener('click', function() {
                document.getElementById('edit_order_id').value = this.dataset.orderId;
                document.getElementById('edit_marzban_username').value = this.dataset.username;
                document.getElementById('username_to_edit').textContent = this.dataset.username;
                editModal.classList.remove('hidden');
            });
        });
        closeEditBtn.addEventListener('click', () => editModal.classList.add('hidden'));
        editModal.addEventListener('click', (e) => {
            if (e.target === editModal) editModal.classList.add('hidden');
        });
    }
});
</script>

<?php include 'includes/footer.php'; ?>